function rntkresultD = RNTKbestresult_D(x,y,data_length,id)
kfold = max(id);
rntkresultD = struct();
param = struct();
lambda = 0;
L = 1;
paramrntk = struct();
paramrntk.sigmaw = [sqrt(2),ones(1,(L-1))];
paramrntk.sigmau = ones(1,L);
paramrntk.sigmav = 1;
paramrntk.sigmab = 0*ones(1,L);
paramrntk.sigmah = 0;
paramrntk.L = L;
paramrntk.nonlinearity = 1;
sigmaw_iter = [sqrt(2),1.34,1.35,1.36,1.37,1.38,1.39,1.40,1.41,1.42,1.43,1.44,1.45,1.46,1.47,1.48];
sigmab_iter = [0,0.01,0.05,0.1,0.2,0.3,0.4,0.5,0.7,0.9,1,2];
sigmah_iter = [0,0.01,0.1,0.5,1];
n1 = length(sigmaw_iter);
n2 = length(sigmab_iter);
n3 = length(sigmah_iter);
mse_test = 10^10;
mse_train = 10^10;
for i = 1:n1
    for j = 1:n2
        for k = 1:n3
            paramrntk.sigmaw = [sigmaw_iter(i),ones(1,(L-1))];
            paramrntk.sigmab = sigmab_iter(j)*ones(1,L);
            paramrntk.sigmah = sigmah_iter(k);
            kernel_train = cell(kfold,1);
            kernel_test = cell(kfold,1);
            y_train = cell(kfold,1);
            y_test = cell(kfold,1);
            train_length = cell(kfold,1);
            test_length = cell(kfold,1);
            for q = 1:kfold
                id_train = find(id ~= q);
                id_test = find(id == q);
                train_length{q} = data_length(id_train);
                test_length{q} = data_length(id_test);
                kernel_train{q} = gramRNTKdifferentlength(x(id_train,:),x(id_train,:),paramrntk,train_length{q},train_length{q});
                kernel_test{q} = gramRNTKdifferentlength(x(id_test,:),x(id_train,:),paramrntk,test_length{q},train_length{q});
                y_test{q} = y(id_test);
                y_train{q} = y(id_train);
            end
            [mse_current_test,mse_current_train,lambda_current] = give_me_best_mse(kernel_train,kernel_test,y_train,y_test);
            if mse_current_test < mse_test
               mse_test = mse_current_test;
               mse_train = mse_current_train;
               lambda = lambda_current;
               param = paramrntk;
            end
            %percent_complete = 100*((i-1)*n2*n3 + (j-1)*n3 + k)/(n1*n2*n3);
            %fprintf('RNTK: %.2f percent complete with best mse: %.5f \n',percent_complete,mse_test);
        end
    end
end
rntkresultD.param = param;
rntkresultD.lambda = lambda;
rntkresultD.mse_test_kfold = mse_test;
rntkresultD.mse_train_kfold = mse_train;

end

